﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

//
//Form2 PreView 2019.1.26
//


namespace Img
{
 
    public partial class Form2 : Form
    {
        int w, h;
        float r;

        string fname;
        int Imgx, Imgy;
        float R,R1,R2;
        public int X0, Y0,MFLG;
        int  X1, Y1;

        private Rectangle rect,rect1;
        private bool blnCut = false;

        public Form2()
        {
            InitializeComponent();

        }

        private void button1_Click(object sender, EventArgs e)
        {
            SaveFileDialog dlg = new SaveFileDialog()
            {
                FileName = label3.Text,
                Filter = "JPEG(*.jpg;*.jpeg)|*.jpg;*.jpeg|PNG(*.png)|*.png|Bitmap(*.bmp)|*.bmp",
                AddExtension = true,
                DefaultExt = ".jpg",
                RestoreDirectory = true,
                OverwritePrompt = true
            };


            if (dlg.ShowDialog() == DialogResult.OK)
            {
               // txtImagePath.Text = dlg.FileName;
                Image img = pictureBox1.Image;
 //               img.Save(dlg.FileName, System.Drawing.Imaging.ImageFormat.Jpeg);

                dlg.Dispose();

                System.IO.FileInfo fileInfo = new System.IO.FileInfo(dlg.FileName);
                
                if (".png".Equals(fileInfo.Extension.ToLower()))
                                {
                                    img.Save(dlg.FileName, System.Drawing.Imaging.ImageFormat.Png);
                                }
                else if (".jpg".Equals(fileInfo.Extension.ToLower()) || ".jpeg".Equals(fileInfo.Extension.ToLower()))
                                {
                                    img.Save(dlg.FileName, System.Drawing.Imaging.ImageFormat.Jpeg);
                                }
                else if (".bmp".Equals(fileInfo.Extension.ToLower()))
                                {
                                    img.Save(dlg.FileName, System.Drawing.Imaging.ImageFormat.Bmp);
                                }

            }

        }

        private void button2_Click(object sender, EventArgs e)
        {

            if (comboBox1.Text.CompareTo("TV") ==0)
            {
                r = (float)(108.0 / 192.0);

            }
            if (comboBox1.Text.CompareTo("2L") == 0)
            {
                r = (float)(12.7 / 17.8);
            }
            if (comboBox1.Text.CompareTo("6ツ") == 0)
            {
                r = (float)(20.3 / 25.4);
            }
            if (comboBox1.Text.CompareTo("A4") == 0)
            {
                r = (float)(21.0 / 29.7);
            }
            if (comboBox1.Text.CompareTo("ハガキ") == 0)
            {
                r = (float)(10.0 / 15.0);
            }

            if (radioButton1.Checked)
            {
                h = (int)((float)rect.Width * r);
                w = rect.Width;
            }
            else
            {
                w = (int)((float)(rect.Height * r));
                h = rect.Height;
            }
            rect.Width = w;
            rect.Height = h;

            DrawRect1();

        }


        private void btnCut_Click(object sender, EventArgs e)
        {   
            if (rect.Width > 0 && rect.Height > 0)
            {
                try
                {
                    rect1 = rect;

                    rect1.Width = (int)((float)rect1.Width * R1);
                    rect1.Height = (int)((float)rect1.Height * R2);
                    rect1.X = (int)((float)rect1.X * R1);
                    rect1.Y = (int)((float)rect1.Y * R2);

                    label1.Text = rect1.Width.ToString();
                    label2.Text = rect1.Height.ToString();

                    // 画像を切り取りサイズにする
                    Bitmap bmp = new Bitmap(rect1.Width, rect1.Height);
                    Graphics grp = Graphics.FromImage(bmp);
                    Bitmap pict = new Bitmap(pictureBox1.Image);
                    // 画像を表示

                    grp.DrawImage(pict, new Rectangle(0, 0, rect1.Width, rect1.Height),
                        rect1, GraphicsUnit.Pixel);
                    grp.Dispose();

                    DataObject data = new DataObject();

                    data.SetData(fname);
                    data.SetData(bmp);
                    Clipboard.SetDataObject(data, true);
                }

                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }
           
 
            Form4 f4 = new Form4();
            f4.ShowDialog(this);


        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        

        private void DrawRect1()
        {
            Graphics grp = pictureBox1.CreateGraphics();
            //青の破線に設定する
            Pen pBox = new Pen(Color.Blue, 1);
            pBox.DashStyle = System.Drawing.Drawing2D.DashStyle.DashDot;
            //描画領域をリフレッシュして線を引く
            pictureBox1.Refresh();
 
            int w = (int)((float)rect.Width * R1) + 10;
            int h = (int)((float)rect.Height * R2);
            label1.Text = w.ToString();
            label2.Text = h.ToString();


            grp.DrawRectangle(pBox,
                rect.X,rect.Y,rect.Width,rect.Height);
            grp.Dispose();
        }

        private void DrawRect(MouseEventArgs e)
        {
            Graphics grp = pictureBox1.CreateGraphics();
            //青の破線に設定する
            Pen pBox = new Pen(Color.Blue, 1);
            pBox.DashStyle = System.Drawing.Drawing2D.DashStyle.DashDot;
            //描画領域をリフレッシュして線を引く
            pictureBox1.Refresh();
            //開始地点より終了地点が前の場合、座標を入れ替えて四角を表示

            rect.Width = Math.Abs(e.X - rect.X);
            rect.Height = Math.Abs(e.Y - rect.Y);

            int w = (int)((float)rect.Width * R1) + 10;
            int h = (int)((float)rect.Height * R2);
            label1.Text = w.ToString();
            label2.Text = h.ToString();


            grp.DrawRectangle(pBox,
                (e.X < rect.X) ? e.X : rect.X,
                (e.Y < rect.Y) ? e.Y : rect.Y,
                rect.Width,
                rect.Height);
            grp.Dispose();
        }
        private void pictureBox1_MouseUp_1(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left && blnCut)
            {
                //四角形を描く
                DrawRect(e);
                //開始地点より終了地点が前の場合、座標を入れ替える
                if (e.X < rect.X)
                {
                    rect.X = e.X;
                }
                if (e.Y < rect.Y)
                {
                    rect.Y = e.Y;
                }
                // 範囲指定の有無で切り取りボタンの押下有無を切り替える
                if (rect.Width > 0 && rect.Height > 0)
                {
                    btnCut.Enabled = true;
                }
                else
                {
                    btnCut.Enabled = false;
                }

                blnCut = false;
            }

        }


        private void pictureBox1_MouseMove_1(object sender, MouseEventArgs e)
        {
            label4.Text = rect.X.ToString();
            if (e.Button == MouseButtons.Left)
            {
                if (blnCut)
                {
                    DrawRect(e);    //四角形を描く
                }

            }
            if (e.Button == MouseButtons.Right && blnCut == false)
            {

                if (e.X > rect.X && rect.X < (rect.X + rect.Width) && e.Y > rect.Y && e.Y < (rect.Y + rect.Height))
                {
                    this.Cursor = Cursors.Hand;
                    int x = e.X - X1;
                    int y = e.Y - Y1;
                    rect.X = rect.X + x;
                    rect.Y = rect.Y + y;

                    DrawRect1();
                    X1 = e.X;
                    Y1 = e.Y;
                }
                else
                {
                    this.Cursor = Cursors.Arrow;
                }
            }

        }


        private void pictureBox1_MouseDown_1(object sender, MouseEventArgs e)
        {
            float rx, ry;

            X0 = e.X;
            Y0 = e.Y;
            if (e.Button == MouseButtons.Middle)
            {
                rx = (int)((float)Imgx / pictureBox1.Width);
                ry = (int)((float)Imgy / pictureBox1.Height);
                X0 = (int)((float)X0 * rx);
                Y0 = (int)((float)Y0 * ry);

                MFLG = 255;
                Close();

            }
            if (e.Button == MouseButtons.Left)
            {
                blnCut = true;
                // 開始地点を記録する
                rect = new Rectangle(e.X, e.Y, 0, 0);


            }
            if (e.Button == MouseButtons.Right && blnCut == false)
            {

                if (e.X > rect.X && rect.X < (rect.X + rect.Width) && e.Y > rect.Y && e.Y < (rect.Y + rect.Height))
                {
                    X1 = e.X;
                    Y1 = e.Y;

                }


            }
        }
 
       private void Form2_Load(object sender, EventArgs e) //PreView
        {
            IDataObject data = Clipboard.GetDataObject();

            if (data.GetDataPresent(DataFormats.Text))
            {
                fname = (string)data.GetData(DataFormats.Text);
                label3.Text = System.IO.Path.GetFileName(fname);
                
            }
            if (data.GetDataPresent(DataFormats.Bitmap))
            {
                pictureBox1.Image = (Image)data.GetData(DataFormats.Bitmap);
            }

            //            pictureBox1.Image=Clipboard.GetImage();
       
            Imgx = pictureBox1.Image.Width;
            Imgy = pictureBox1.Image.Height;
            int P_MarginW = Width - panel1.Width;
            int P_MarginH = Height - panel1.Height;

            R = Imgx / (float)Imgy;
            if (Imgx < Imgy)
            {
                Height = 1000;
                Width= (int)((float)panel1.Height * R)+P_MarginW;
                //Width = (int)((float)Height* R);
               
            }
            else
            {
                Width = 1000;
                Height = (int)((float)panel1.Width / R)+P_MarginH;
               // Height = (int)((float)Width / R);
               
            }
            R1 = (float)Imgx / (float)pictureBox1.Width; 
            R2 = (float)Imgy / (float)pictureBox1.Height;
            X0 = 0;
            Y0 = 0;
            X1 = 0;
            Y1 = 0;
        }
    }
}
